﻿var scheduleQuota = {
    context: $(".v-scheduleQuotas"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-scheduleQuotasTable", scheduleQuota.context).a4datatable({
            //advancedFilter: true,
            multiEdit: voxco.security.has('USE_QUOTA_SCH'),
            stateKey: "QuotasSchedules",
            ajaxAction: a4.getProjectAction("GetSchedules", "Quotas"),
            columns: [
                { "Name": "Id", "Key": true},
                { "Title": resources.Label, "Name": "Label", "Editable": true },
                { "Title": resources.Monday, "Name": "Day2", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Tuesday, "Name": "Day3", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Wednesday, "Name": "Day4", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Thursday, "Name": "Day5", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Friday, "Name": "Day6", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Saturday, "Name": "Day7", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Sunday, "Name": "Day1", "ShowIcon": true, "Type": "boolean", "Editable": true },
                { "Title": resources.Action, "Data": "Action", "Name": "Action", "Type": "enum", "EnumType": "ScheduleAction", "Editable": true },
                { "Title": resources.Time, "Data": "TimeFormatted", "Name": "Time", "Editable": true, "Type": "time" }
            ],
            localizableTexts: { "Search": resources.SearchSchedules },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var scheduleIds = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        scheduleQuota.deleteSchedules(scheduleIds);
                        break;
                };
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        scheduleQuota.deleteSchedules([row.Id]);
                        break;

                    case "properties":
                        scheduleQuota.editSchedules(row.Id);
                        break;
                }
            },
            rowUpdated: function (even, data) {
                var pattern = /[\d]{1,2}:[\d]{2}/g;
                var fieldName = data.fieldName;
                var row = data.data;
                var labelColumn = row.Label;
                var timeColumn = row.TimeFormatted;
                
                if (fieldName == "Label" && (labelColumn.length > 4 || labelColumn.length == 0)) {
                    data.flagError(true);
                }
                else if (fieldName == "TimeFormatted" && !pattern.test(timeColumn)) {
                    data.flagError(true);
                }

                if (!(row.Day1 || row.Day2 || row.Day3 || row.Day4 || row.Day5 || row.Day6 || row.Day7)) {
                    data.flagError(true, true);
                }
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateSchedule", "Quotas"), { schedule: data.rows },
                function () {
                    data.multiEditSaveCallback();
                });
            }
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    bindEvents: function () {
        scheduleQuota.context.on("click", ".h-addSchedule", function () {
            modalDialog.showWindow(a4.getProjectAction("AddSchedule", "Quotas"), 500, 650, {
                afterClose: function () {
                    scheduleQuota.refreshContent();
                }
            });
        });

        scheduleQuota.context.on("click", ".h-copySchedule", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopySchedule", "Quotas"), { sourceProjectId: sourceProjectId },
                function (result) {
                    scheduleQuota.refreshContent();
                });
            }, resources.CopySchedule);
        });
    },
    deleteSchedules: function (scheduleIds) {
        modalDialog.showConfirmDelete(confirmDeleteStrataScheduleResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteSchedules", "Quotas"), { scheduleIds: scheduleIds },
                function (result) {
                    scheduleQuota.refreshContent();
                });
        }, scheduleIds.length);
    },
    editSchedules: function (scheduleId) {
        modalDialog.showWindow(a4.getProjectAction("AddSchedule", "Quotas", { scheduleId: scheduleId }), 500, 650, { afterClose: function () { scheduleQuota.refreshContent(); } });
    }
}

$(document).ready(function () {
    if (scheduleQuota.context.length > 0) {
        scheduleQuota.initializeDataTable();
        scheduleQuota.bindEvents();
    }
});